/**
 * Created by Administrator on 2016/8/24.
 */
appModule.directive("pageIcons", ["pages", "utils", function (pages, utils) {
    return {
        template: ' <i class="icon-close close" ng-click="onClose()"></i>'
        + '<i class="icon-max maximize" ng-class="{\'icon-restore\':isMaximized}" ng-click="toggleMaximize()"></i>'
        + '<i class="icon-min minimize" ng-click="minimize()"></i>',
        restrict: "E",
        scope: {
            onClose: "&",
            isMinimized: "=",
            isMaximized: "=",
            onlyClose: "@"
        },
        link: function ($scope, element) {

            $scope.toggleMaximize = function () {
                $scope.isMinimized = false;
                if ($scope.isMaximized) {
                    $scope.isMaximized = false;
                    pages.restoreWindow();
                    return;
                }

                $scope.isMaximized = true;
                pages.maximizeWindow();
            };

            $scope.minimize = function () {
                $scope.isMinimized = true;
                pages.minimizeWindow();
            };

            function onWindowRestored() {
                utils.applyScope($scope, function () {
                    $scope.isMaximized = false;
                });
            }

            function onWindowMax() {
                utils.applyScope($scope, function () {
                    if ($scope.isMinimized) {
                        $scope.isMinimized = false;
                    }
                    $scope.isMaximized = true;
                });
            }

            if ($scope.onlyClose) {
                $('.icon-max,.icon-min', element).hide();
            } else {
                pages.addWindowRestoreListener(onWindowRestored);
                pages.addWindowMaxListener(onWindowMax);
            }
            $scope.$on("$destroy", function () {
                pages.removeWindowRestoreListener(onWindowRestored);
                pages.removeWindowMaxListener(onWindowMax);
            });
        }
    };
}]);